<?php
session_start();
include($_SERVER['DOCUMENT_ROOT'] . '/db_config.php');

// Create PDO connection
try {
    $conn = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    // Set the PDO error mode to exception
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Connection failed: " . $e->getMessage());
}

// Check if session is set
if (!isset($_SESSION['email'])) {
    header("Location: signup.php?error=session_expired");
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $code = $_POST['code'];
    $email = $_SESSION['email'];

    // Verify code
    try {
        $stmt = $conn->prepare("SELECT id FROM users WHERE email = :email AND verification_code = :code");
        $stmt->bindParam(':email', $email);
        $stmt->bindParam(':code', $code);
        $stmt->execute();

        if ($stmt->rowCount() > 0) {
            // Update is_verified status
            $stmt = $conn->prepare("UPDATE users SET is_verified = 1 WHERE email = :email");
            $stmt->bindParam(':email', $email);
            $stmt->execute();

            // Check if update was successful
            if ($stmt->rowCount() > 0) {
                // Redirect to dashboard after successful verification
                header("Location: /dashboard.php?message=verification_success");
                exit;
            } else {
                echo "<div class='error'>Failed to update verification status. Please try again.</div>";
            }

        } else {
            echo "<div class='error'>Invalid verification code. Please try again.</div>";
        }
    } catch (PDOException $e) {
        echo "Error: " . $e->getMessage();
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Email Verification</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --sidebar-bg: #14213d;
            --sidebar-text: #a8b2d1;
            --sidebar-hover: #1a2c5b;
            --active-link: #2a4494;
            --primary-text: #fff;
            --secondary-text: #fff;
            --card-bg: #1c1c28;
            --main-bg: #1c1c28;
            --deposit-color: #3498db;
            --withdraw-color: #e74c3c;
            --button-color: #0d6efd;
            --hover-color: #0b5ed7;
            --success-color: #28a745;
            --error-color: #dc3545;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;
        }

        body {
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            background-color: var(--main-bg);
            padding: 20px;
        }

        .verification-container {
            background-color: var(--card-bg);
            border-radius: 10px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
            padding: 40px;
            width: 100%;
            max-width: 480px;
            text-align: center;
        }

        .verification-icon {
            font-size: 48px;
            color: var(--button-color);
            margin-bottom: 20px;
        }

        .verification-title {
            font-size: 24px;
            font-weight: 600;
            color: var(--primary-text);
            margin-bottom: 15px;
        }

        .verification-description {
            color: var(--secondary-text);
            margin-bottom: 25px;
            line-height: 1.5;
        }

        .form-group {
            margin-bottom: 20px;
            text-align: left;
        }

        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: 500;
            color: var(--primary-text);
        }

        .form-control {
            width: 100%;
            padding: 12px 15px;
            font-size: 16px;
            border: 1px solid #ddd;
            border-radius: 6px;
            transition: border-color 0.3s;
        }

        .form-control:focus {
            border-color: var(--button-color);
            outline: none;
            box-shadow: 0 0 0 3px rgba(13, 110, 253, 0.15);
        }

        .verify-btn {
            width: 100%;
            padding: 12px;
            background-color: var(--button-color);
            color: white;
            border: none;
            border-radius: 6px;
            font-size: 16px;
            font-weight: 500;
            cursor: pointer;
            transition: background-color 0.3s;
        }

        .verify-btn:hover {
            background-color: var(--hover-color);
        }

        .message {
            padding: 12px;
            border-radius: 6px;
            margin-bottom: 20px;
            font-size: 14px;
        }

        .error-message {
            background-color: rgba(220, 53, 69, 0.1);
            color: var(--error-color);
            border-left: 4px solid var(--error-color);
        }

        .success-message {
            background-color: rgba(40, 167, 69, 0.1);
            color: var(--success-color);
            border-left: 4px solid var(--success-color);
        }

        .resend-link {
            color: var(--button-color);
            text-decoration: none;
            font-weight: 500;
            transition: color 0.3s;
        }

        .resend-link:hover {
            color: var(--hover-color);
            text-decoration: underline;
        }

        .footer-text {
            margin-top: 20px;
            color: var(--secondary-text);
            font-size: 14px;
        }

        @media (max-width: 576px) {
            .verification-container {
                padding: 30px 20px;
            }
            
            .verification-title {
                font-size: 20px;
            }
            
            .form-control {
                padding: 10px 12px;
            }
        }
    </style>
</head>
<body>
    <div class="verification-container">
        <div class="verification-icon">
            <i class="fas fa-envelope"></i>
        </div>
        <h1 class="verification-title">Email Verification</h1>
        <p class="verification-description">We've sent a verification code to your email address. Please enter it below to verify your account.</p>
        
        <?php if (!empty($error_message)): ?>
            <div class="message error-message"><?= htmlspecialchars($error_message) ?></div>
        <?php endif; ?>
        
        <form method="POST" action="email_verification.php">
            <div class="form-group">
                <label for="code">Verification Code</label>
                <input type="text" id="code" name="code" class="form-control" placeholder="Enter 6-digit code" required>
            </div>
            
            <button type="submit" class="verify-btn">Verify Email</button>
        </form>
        
    
    </div>
</body>
</html>